/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.repository.remote;

import java.io.File;
import java.util.Map;
import javax.swing.JComboBox;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.repository.remote.RemoteRepositoryPanel;
import org.netbeans.modules.git.ui.repository.remote.RemoveRemoteConfig;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class RemoveRemoteAction
extends SingleRepositoryAction {
    @Override
    public void performAction(File repository, File[] roots, VCSContext context) {
        String remoteName;
        GitRemoteConfig remote = context != null ? (GitRemoteConfig)context.getElements().lookup(GitRemoteConfig.class) : null;
        String string = remoteName = remote != null ? remote.getRemoteName() : null;
        if (remoteName == null) {
            Map<String, GitRemoteConfig> remotes = RepositoryInfo.getInstance(repository).getRemotes();
            if (remotes.isEmpty()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(RemoteRepositoryPanel.class, (String)"LBL_RemoveRemoteAction_noRemotes")));
                return;
            }
            JComboBox<String> combo = new JComboBox<String>(remotes.keySet().toArray(new String[0]));
            NotifyDescriptor nd = new NotifyDescriptor(combo, NbBundle.getMessage(RemoteRepositoryPanel.class, (String)"LBL_RemoveRemoteAction_Select"), 2, -1, null, null);
            if (DialogDisplayer.getDefault().notify(nd) != NotifyDescriptor.OK_OPTION) {
                return;
            }
            remoteName = (String)combo.getSelectedItem();
        }
        new RemoveRemoteConfig().removeRemote(repository, remoteName);
    }
}

